# install.packages("ggplot2")

library(ggplot2)

# Set workspace
setwd("enter your folder here")

# Read text file
df <- read.csv(file="OM trends dataset.csv",head=TRUE,sep=",")

# Print data frame
df

# Make plot
OMgrad <- ggplot(df, aes(x = xadjusted, y = OM)) + 
  geom_rect(aes(xmin=-1.5, xmax=+1.5, ymin=0, ymax=Inf)) +
  geom_line(aes(color = Sample), size = 1) + 
  scale_color_manual(values = c("violetred2", "chocolate1", "darkgrey", "navyblue", "springgreen3")) +
  geom_point(aes(color = Sample, shape = Sample)) + 
  scale_shape_manual(values = c(21, 22, 23, 24, 25)) +
  theme(legend.position=c(0.1,0.8)) +
  
  xlab('Vertical distance [cm] (origin set at 40% OM intersect)') +
  ylab('Organic matter content [%]') +
  
  geom_hline(yintercept=40,linetype="dashed",size=1) +
  geom_hline(yintercept=35,linetype="dotted",size=.5) +
  geom_hline(yintercept=45,linetype="dotted",size=.5) +
  
  xlim(-15.5, 16.5) +
  ylim(0, 100)

# Show plot
OMgrad

# Save plot
ggsave("OMgradient.png", plot=OMgrad, height=16, width=20, units=c("cm"), dpi=600)